(function ($) {
	"use strict";
	
    // Submit loader mask 
    $('form#wrapped').on('submit', function () {
    	var form = $("form#wrapped");
    	form.validate();
    	if (form.valid()) {
    		$("#loader_form").fadeIn();
    	}
    });
    
    // Show Password
    $('#password1, #password2').hidePassword('focus', {
    	toggle: {
    		className: 'my-toggle'
    	}
    });
    
    $(document).ready(function() {
    	var password1 		= $('#password1'); //id of first password field
    	var password2		= $('#password2'); //id of second password field
    	var passwordsInfo 	= $('#pass-info'); //id of indicator element
    	passwordStrengthCheck(password1,password2,passwordsInfo); //call password check function
    });
    
    function passwordStrengthCheck(password1, password2, passwordsInfo){
    	//Must contain 5 characters or more
    	var WeakPass = /(?=.{5,}).*/; 
    	//Must contain lower case letters and at least one digit.
    	var MediumPass = /^(?=\S*?[a-z])(?=\S*?[0-9])\S{5,}$/; 
    	//Must contain at least one upper case letter, one lower case letter and one digit.
    	var StrongPass = /^(?=\S*?[A-Z])(?=\S*?[a-z])(?=\S*?[0-9])\S{5,}$/; 
    	//Must contain at least one upper case letter, one lower case letter and one digit.
    	var VryStrongPass = /^(?=\S*?[A-Z])(?=\S*?[a-z])(?=\S*?[0-9])(?=\S*?[^\w\*])\S{5,}$/; 
    	$(password1).on('keyup', function(e) {
    		if(VryStrongPass.test(password1.val())){
    			passwordsInfo.removeClass().addClass('vrystrongpass').html("Very Strong! (Awesome, please don't forget your pass now!)");
    		}	
    		else if(StrongPass.test(password1.val())){
    			passwordsInfo.removeClass().addClass('strongpass').html("Strong! (Enter special chars to make even stronger");
    		}	
    		else if(MediumPass.test(password1.val())){
    			passwordsInfo.removeClass().addClass('goodpass').html("Good! (Enter uppercase letter to make strong)");
    		}
    		else if(WeakPass.test(password1.val())){
    			passwordsInfo.removeClass().addClass('stillweakpass').html("Still Weak! (Enter digits to make good password)");
        	}
    		else{
    			passwordsInfo.removeClass().addClass('weakpass').html("Very Weak! (Must be 5 or more chars)");
    		}
    	});
    	$(password2).on('keyup', function(e) {
    		if(password1.val() !== password2.val()){
    			passwordsInfo.removeClass().addClass('weakpass').html("Passwords do not match!");	
    		}else{
    			passwordsInfo.removeClass().addClass('goodpass').html("Passwords match!");	
    		}
    	});
    }
    
    $('form#wrapped').attr('action', 'register');
    $("#wizard_container").wizard({
    	stepsWrapper: "#wrapped",
    	submit: ".submit",
    	beforeSelect: function (event, state) {
    		if (!state.isMovingForward)
    			return true;
    		var inputs = $(this).wizard('state').step.find(':input');
    		return !inputs.length || !!inputs.valid();
    	}
    }).validate({
    	errorPlacement: function (error, element) {
    		if (element.is(':radio') || element.is(':checkbox')) {
    			error.insertBefore(element.next());
    		} else {
    			error.insertAfter(element);
    		}
    	}
    });
    //  progress bar
    $("#progressbar").progressbar();
    $("#wizard_container").wizard({
    	afterSelect: function (event, state) {
    		$("#progressbar").progressbar("value", state.percentComplete);
    		$("#location").text("(" + state.stepsComplete + "/" + state.stepsPossible + ")");
    	}
    });
    // Validate select
    $('#wrapped').validate({
    	ignore: [],
    	rules: {
    		select: {
    			required: true
    		}
    	},
    	errorPlacement: function (error, element) {
    		if (element.is('select:hidden')) {
    			error.insertAfter(element.next('.nice-select'));
    		} else {
    			error.insertAfter(element);
    		}
    	}
    });
    	
    function getVals(formControl, controlType) {
    	switch (controlType) {
    		case 'first_name':
    			// Get the value for a input text
    			var value = $(formControl).val();
    			$("#first_name").text(value);
    			break;
    
    		case 'last_name':
    			// Get the value for a input text
    			var value = $(formControl).val();
    			$("#last_name").text(value);
    			break;
    
    		case 'email':
    			// Get the value for a input text
    			var value = $(formControl).val();
    			$("#email").text(value);
    			break;
    
    		case 'user_name':
    			// Get the value for a input text
    			var value = $(formControl).val();
    			$("#user_name").text(value);
    			break;
    
    		case 'password':
    			// Get the value for a input text
    			var value = $(formControl).val();
    			$("#password").text(value);
    			break;
    	}
    }
    
    $('#fn').on('change', function(){ getVals(this, "first_name"); } );
    $('#ln').on('change', function(){ getVals(this, "last_name"); } );
    $('#em').on('change', function(){ getVals(this, "email"); } );
    $('#un').on('change', function(){ getVals(this, "user_name"); } );
    $('#pw').on('change', function(){ getVals(this, "password"); } );
})(jQuery);